<?php

namespace Import\ApiBundle\Services\Import;


class ImportMinPayment extends ImportMainService
{
    protected $url = 'http://www.wskazniki.pl/?doc_id=189653&iid=4638';

    protected $columns = array("Okres","Value");

    protected $errors = array();

    public function import()
    {
        $this->type = 'ImportMinPayment';
        $data = $this->getPaymentMinFromPage($this->url);

        $count = $this->save($data);
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function save($data)
    {
        $LastMinPayment = $this->getDoctrine()->getRepository('ImportApiBundle:PaymentMin')->getLastMinPayment();
        $count = 0;

        if(empty($LastMinPayment) || $data['DataFrom'] > $LastMinPayment->getDataFrom())
        {
            if(!empty($LastMinPayment))
            {
                $dateYesterday = clone $data['DataFrom'];
                $dateYesterday->modify('-1 day');
                $LastMinPayment->setDataTo($dateYesterday);
                $this->getDoctrine()->getEntityManager()->persist($LastMinPayment);
            }
            $this->getDoctrine()->getRepository('ImportApiBundle:PaymentMin')->add($data);
            $count++;
        }
        $this->getDoctrine()->getEntityManager()->flush();
        return $count;
    }
}